-- Präsenzzeit: Validierung; Berechnung: Rundung, Karenz, Pausen; Übergabe an Mitarbeiterplan
-- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Stempeln

CREATE OR REPLACE FUNCTION bdep__b_20_iu() RETURNS TRIGGER AS $$
  DECLARE
      time1               time(0);
      time2               time(0);
      tplanname           varchar;
      f                   numeric;
      f1                  numeric;
      f2                  numeric;
      f3                  numeric;
      f4                  numeric;
      tplananfmin         integer;
      tplanendmin         integer;
      tplrund             numeric;
      b                   boolean;
      rp                  numeric;
      gestempelte_pause   numeric;
      r                   record;
      planRec             record;
      selectmontagsplan   boolean;
      _recalc_pausensaldo boolean;
      _stunden_dienstgang_during_bdep numeric;
  BEGIN
    IF current_user = 'syncro' OR new.bd_buch THEN RETURN new; END IF; -- Änderungen verwerfen. Das ist bereits verbucht.

    IF TG_OP = 'INSERT' AND NOT check_valid_bde_date(new.bd_minr, new.bd_individwt_mpl_date) THEN
        RAISE EXCEPTION 'date in past:insert bdep MitNr:%, date:%', new.bd_minr, new.bd_individwt_mpl_date; -- Fehler: Datum nicht valide.
    END IF;

    -- Wenn PZE für Nutzer erlaubt
    -- IF TG_OP='INSERT' AND TSystem.Settings__GetBool('BDENoPrsz') THEN -- #10584 -- Wurde ersetzt mit nutzerspez. Freigabe.
    IF TG_OP = 'INSERT' AND NOT (SELECT ll_prszzeit FROM llv WHERE ll_minr = new.bd_minr) THEN
        RAISE EXCEPTION '%', lang_text(16476) || ' ' || new.bd_minr || E'\n';
    END IF;

    -- 1. Stempelsatz des Tages. Zur Anzeige von Bearbeiten Stempeln tabellarisch.
    IF EXISTS(SELECT true FROM bdep WHERE bd_minr = new.bd_minr AND bd_individwt_mpl_date = new.bd_individwt_mpl_date AND bd_anf < new.bd_anf AND bd_id <> new.bd_id) THEN
        new.bd_firstofday := false;
    ELSE
        new.bd_firstofday := true;
    END IF;

    IF NOT (TG_OP = 'INSERT') THEN
        -- Bei verbuchten Sätzen einfach alles ignorieren, deshalb hier prüfen ob verbucht.
        IF old.bd_buch THEN IF NOT new.bd_buch THEN RETURN new; ELSE RETURN old; END IF; END IF; -- Satz festmachen oder halt zurücksetzen

        -- Sonst bei Änderungen Berechnung initialisieren.
        IF (new.bd_anf <> old.bd_anf OR new.bd_end <> old.bd_end OR old.bd_end IS NULL) THEN
            new.bd_blockpause := NULL;
            new.bd_gleitpause := NULL;
        END IF;
    END IF;

    -- keine zweite Anstempelung
    IF new.bd_end IS NULL AND TG_OP = 'INSERT' AND coalesce(new.insert_by, '') <> 'NT' THEN
        IF EXISTS(SELECT true FROM bdep WHERE bd_minr = new.bd_minr AND bd_end IS NULL AND bd_id <> new.bd_id) THEN
            RAISE EXCEPTION 'xtt5041 cannot insert 2nd "BEGIN WORK" record: minr:%', new.bd_minr;
        END IF;
    END IF;

    -- keine Überlappung / Überschneidung
    IF coalesce(new.insert_by, '') <> 'NT' THEN
        BEGIN
            IF EXISTS(
              SELECT true
              FROM bdep
              WHERE bd_id <> new.bd_id
                AND bd_minr = new.bd_minr
                -- Einschränkung zwecks Performance
                -- timestamp_to_date(bd_anf) geht über Index, daher kein CAST.
                AND timestamp_to_date(bd_anf) BETWEEN new.bd_anf::date - 1 AND new.bd_anf::date + 1
                -- Bereiche überlappen sich. Inklusive der Grenzen
                -- Keine unbeschränkte Prüfung (bei Ende ist NULL), sondern dann punktuell, siehe #14029
                AND tsrange(bd_anf,     coalesce(bd_end, bd_anf),         '[]')
                    &&
                    tsrange(new.bd_anf, coalesce(new.bd_end, new.bd_anf), '[]')
            ) THEN
                RAISE EXCEPTION '';
            END IF;
        EXCEPTION WHEN others THEN
            RAISE EXCEPTION 'xtt5042 Überlappung / Überschneidung der Stempelungen bd_id|MA-Nr.|Anf.|Ende|IP = %|%|%|%|%', new.bd_id, new.bd_minr, new.bd_anf, new.bd_end, new.bd_terminal;
        END;
    END IF;

    -- Wir haben vergessen abzustempeln.
    -- Maximale Dauer einer Präsenzzeit-Stempelung ist 15 h.
    IF timediff(new.bd_anf, new.bd_end) > 15 THEN
        -- Dauer der Stempelung minimieren
        new.bd_end := new.bd_anf + '00:00:01'::time;
        -- Eintrag vom eigentlichen Start, siehe bdep__a_20_iu__insert__bdep__fehlstempelung, siehe #14106.
    END IF;

    -- Falls noch kein Tag in mitpln, diesen jetzt erstellen (Tagesplan wird dort selbst eingetragen).
    IF NOT EXISTS(SELECT true FROM mitpln WHERE mpl_minr = new.bd_minr AND mpl_date = new.bd_individwt_mpl_date) THEN
        -- Option"Tagesplan selbst wählen"
        SELECT ll_selecttplan INTO selectmontagsplan FROM llv WHERE ll_minr = new.bd_minr;

        IF selectmontagsplan THEN -- den letzten Sonn/Montagstageplan ermitteln
            SELECT mpl_tpl_name INTO tplanname FROM mitpln WHERE mpl_minr = new.bd_minr AND mpl_date > current_date - 6 AND extract(dow FROM mpl_date) IN (0, 1) ORDER BY mpl_date LIMIT 1;
        END IF;

        IF NOT selectmontagsplan OR tplanname IS NULL THEN
            -- Ermittelt den Tagesplan anhand der 1. Stempelung
            -- Hier keine Verwendung von ind. WT möglich. Könnte im Zweifel widersprl. sein.
            tplanname := tpersonal.bde__llv_standplan__get(new.bd_anf::date, new.bd_anf::time(0), new.bd_minr);
        END IF;

        -- Initiierung des Tagesplans
        -- Zur Erhaltung der Konsistenz muss hier der ind. WT genommen werden.
        INSERT INTO mitpln (mpl_date, mpl_minr, mpl_tpl_name) VALUES (new.bd_individwt_mpl_date, new.bd_minr, tplanname);

    -- Tagesplan ist für den Tag schon zugewiesen
    ELSE
        tplanname := mpl_tpl_name FROM mitpln WHERE mpl_date = new.bd_individwt_mpl_date AND mpl_minr = new.bd_minr;
    END IF;

    SELECT  tpl_zeitrund, extract(minute FROM tpl_rbegin),  extract(minute FROM tpl_rend)
    INTO    tplrund,      tplananfmin,                      tplanendmin
    FROM tplan
    WHERE tpl_name = tplanname;

    -- Nachtschicht-Tagesplan manchmal als 0:00-23.59.59 gegeben => Endzeit korrekt runden
    IF tplanendmin = 59 THEN
        tplanendmin := 0;
    END IF;

    --runden von anfangsstempelung
    new.bd_anf_rund := new.bd_anf;
    new.bd_end_rund := new.bd_end;

    IF new.bd_karenz THEN
        new.bd_anf_rund := tpersonal.karenz_kr_newtime_from(new.bd_anf, tplanname);
    END IF;

    --Anfangszeit runden
    IF tplanname IS NULL THEN -- kein Tagesplan vorhanden, dann minutengenau
        new.bd_anf_rund := date_trunc('minute', new.bd_anf);
    ELSE
        -- mindestens 1 Minute
        tplrund := greatest(tplrund, 1);

        -- Wir schauen zuerst, ob die Anfangszeit auch in die Rundung passt, ansonsten müssen wir eine Differenz einbeziehen.
        f  := tplananfmin; -- s.o.
        f3 := f % tplrund; -- Damit haben wir die Anzahl von Minuten, die der Rundung vornweg ist.
          -- so z.Bsp 2 wenn Anfangszeit 7:02 und Rundung 15
          -- oder 10 wenn anfangszeit 55 und Rundung 15

        f  := extract(minute  FROM new.bd_anf_rund - ('0:' || f3::varchar)::time);
        f4 := extract(hour    FROM new.bd_anf_rund - ('0:' || f3::varchar)::time);
        f1 := trunc(f / tplrund); -- Restanteil
        f2 := (f / tplrund); -- Restanteil

        IF f2 > f1 THEN -- Wir haben also einen Fall, in dem abgerundet werden muss.
            f1 := f1 + 1;
        END IF;

        f2 := 0; -- bei Überschreiten der Stunde
        IF f1 * tplrund >= 60 THEN -- Wir schießen über die Stunde Hinaus.
            f2 := 1;
            f1 := 0;
        END IF;

        new.bd_anf_rund := new.bd_anf::date || ' ' || f4 + f2 || ':' || f1 * tplrund;

        -- Falls wir am Anfang wegen verschobener Anfangs- und Endezeiten eine Abweichung hatten, muss diese jetzt wieder drauf.
        new.bd_anf_rund := new.bd_anf_rund + ('0:' || f3::varchar)::time;

        -- Neue Berechnung des ganze Blocks:
          -- new.bd_anf_rund := date_trunc('minute', new.bd_anf) +
              -- Wieviel muss ich zu den Differenzminuten (Plan, Stempel) addieren, damit die Rundung stimmt.
              -- Stichwort: Restklassenring
          -- ((((tplananfmin - date_part('minutes', new.bd_anf))::integer % tplrund) + tplrund) % tplrund) * '1 minute'::INTERVAL;

    END IF;

    IF new.bd_karenz_end THEN
        new.bd_end_rund := tpersonal.karenz_kr_newtime_from(new.bd_end, tplanname);
    END IF;

    -- Endezeit runden
    IF tplanname IS NULL THEN -- kein Tagesplan vorhanden, dann minutengenau
        new.bd_end_rund := date_trunc('minute', new.bd_end);
    ELSE
        -- Mindestens 1 Minute
        tplrund := greatest(tplrund, 1);

        f  := tplanendmin;
        f3 := f % tplrund; -- Damit haben wir die Anzahl von Minuten, die der Rundung vornweg ist.
        --
        f  := extract(minute  FROM new.bd_end_rund - ('0:' || f3::varchar)::time);
        f2 := extract(hour    FROM new.bd_end_rund - ('0:' || f3::varchar)::time);
        f1 := trunc(f / tplrund);
        new.bd_end_rund := timestamp_to_date(new.bd_end) || ' ' || f2 || ':' || f1 * tplrund;

        -- Ffalls wir am Anfang wegen verschobener Anfangs- und Endezeiten eine Abweichung hatten, muss diese jetzt wieder drauf.
        new.bd_end_rund := new.bd_end_rund + ('0:' || f3::varchar)::time;

        IF current_user = 'root' THEN -- Debug
            RAISE NOTICE 'bd_end_rund 623: %', new.bd_end_rund;
        END IF;

        -- Neue Berechnung des ganze Blocks:
          -- new.bd_end_rund:=date_trunc('minute', new.bd_end) -
              -- Wieviel muss ich von den Differenzminuten (Stempel, Plan) abziehen, damit die Rundung stimmt.
              -- Stichwort: Restklassenring
          --((((date_part('minutes', new.bd_end) - tplanendmin)::integer % tplrund) + tplrund) % tplrund) * '1 minute'::INTERVAL;
    END IF;

    -- Abfangen, dass bei kurzen Stempelungen sowie Zeitrundungen negative Salden entstehen.
    IF new.bd_end_rund < new.bd_anf_rund THEN
        new.bd_end_rund := new.bd_anf_rund;
    END IF;

    -- Anstempeln/Anfangszeit ändern, letzte Pause berücksichtigen
    IF TG_OP = 'INSERT' OR new.bd_gleitpause IS NULL THEN
        new.bd_gleitpause := 0;
    END IF;

    -- Bei Entfernen der Ende-Zeit Summen zurücksetzen, #14431
    IF TG_OP = 'UPDATE' THEN
        IF new.bd_end_rund IS NULL AND old.bd_end_rund IS NOT NULL THEN
            -- alle Summen bei kommendem "RECHENBLOCK FÜR ALLES"
            new.bd_blockpause   := NULL;
            new.bd_restpause    := NULL;
            new.bd_nachtstunden := NULL;
            new.bd_saldo        := NULL;
            -- nicht NULL, s.o.
            new.bd_gleitpause   := 0;
        END IF;
    END IF;

    -- RECHENBLOCK FÜR ALLES BEI Abstempeln = Eintragen der Statischen Daten (Saldo und Restpause und Gleitpause und Blockpause)
    IF new.bd_end_rund IS NOT NULL THEN
        -- Pausen durch Blockzeiten
        -- Blockzeiten für Nachtschichten (als Tagesplan) nicht implementiert, siehe TRIGGER check_tplanblock.
        IF new.bd_blockpause IS NULL THEN
            time1 := -- Beginn der Blockzeit innerhalb der Stempelzeit
              MIN(tplbl_begin) FROM tplanblock
              WHERE tplbl_tpl_name = tplanname
                AND (
                     new.bd_anf_rund::time BETWEEN tplbl_begin AND tplbl_end
                  OR new.bd_end_rund::time BETWEEN tplbl_begin AND tplbl_end
                  OR (
                        new.bd_anf_rund::time < tplbl_begin
                    AND new.bd_end_rund::time > tplbl_end
                  )
                )
            ;

            time2 := -- Ende der Blockzeit innerhalb der Stempelzeit
              MAX(tplbl_end) FROM tplanblock
              WHERE tplbl_tpl_name = tplanname
                AND (
                     new.bd_anf_rund::time BETWEEN tplbl_begin AND tplbl_end
                  OR new.bd_end_rund::time BETWEEN tplbl_begin AND tplbl_end
                  OR (
                        new.bd_anf_rund::time < tplbl_begin
                    AND new.bd_end_rund::time > tplbl_end
                  )
                )
            ;

            -- Zuerts prüfen ob eine andere Stempelung schon den Pausenabzug dieser Blockzeit erhalten hat.
            IF NOT EXISTS(
              SELECT true FROM bdep
              WHERE bd_anf_rund::date = new.bd_anf_rund::date
                AND bd_minr = new.bd_minr
                AND bd_id <> new.bd_id
                AND bd_blockpause > 0
                AND (
                     bd_anf_rund::time BETWEEN time1 AND time2
                  OR bd_end_rund::time BETWEEN time1 AND time2
                  OR (
                        bd_anf_rund::time < time1
                    AND bd_end_rund::time > time2
                  )
                )
              )
            THEN
                f := -- gesamte Blockpausenzeit in Zeitraum
                  SUM(tplbl_pause)::numeric
                  FROM tplanblock
                  WHERE tplbl_tpl_name = tplanname
                    AND (
                         tplbl_begin BETWEEN new.bd_anf_rund::time AND new.bd_end_rund::time
                      OR tplbl_end   BETWEEN new.bd_anf_rund::time AND new.bd_end_rund::time
                      OR (new.bd_anf_rund::time >= tplbl_begin AND new.bd_end_rund::time <= tplbl_end)
                      -- Nachtschicht
                      OR (new.bd_anf_rund::date < new.bd_end_rund::date AND tplbl_begin >= new.bd_anf_rund::time AND tplbl_end <= new.bd_end_rund::time)  -- innen
                      OR (new.bd_anf_rund::date < new.bd_end_rund::date AND tplbl_begin <  new.bd_anf_rund::time AND tplbl_end >  new.bd_end_rund::time)  -- aussen
                      OR (new.bd_anf_rund::date < new.bd_end_rund::date AND tplbl_begin >= new.bd_anf_rund::time AND tplbl_end >= new.bd_end_rund::time)  -- mitten rein
                      OR (new.bd_anf_rund::date < new.bd_end_rund::date AND tplbl_begin <= new.bd_anf_rund::time AND tplbl_end <= new.bd_end_rund::time)  -- mitten rein
                    )
                ;
            ELSE
                f := 0;
            END IF;

            new.bd_blockpause := coalesce(f, 0) / 60;
        END IF; -- Blockpause IS NULL => neu ermitteln


        -- äußere Leerzeichen und Leerstring im Stempel-Hint entfernen.
        new.bd_stemphint := nullif( trim( new.bd_stemphint ), '' );

        -- Blockzeitverletzung
        IF
            EXISTS(
              SELECT true
              FROM tplanblock
              WHERE tplbl_tpl_name = tplanname
                AND (
                        new.bd_anf_rund::time BETWEEN tplbl_begin AND tplbl_end
                    OR  new.bd_end_rund::time BETWEEN tplbl_begin AND tplbl_end
                )
            )

        THEN

            -- Hinweise auf Blockzeitverletzung (BV) anfügen.
              -- wenn BV noch nicht eingetragen ist.
              -- SN des Gerätes mitspeichern.
            IF
                    new.bd_stemphint IS NULL
                OR  (
                        new.bd_stemphint <> 'BV'
                    AND new.bd_stemphint NOT LIKE '% BV'
                )

            THEN

                new.bd_stemphint := concat_ws( ' ', new.bd_stemphint, 'BV' );

            END IF;

        END IF;

        -- Gleitzeitpause
        new.bd_restpause  := 0;
        new.bd_gleitpause := 0;
        -- 0) Pause voll eingestempelt. Die komplette Pause wird von der Zeit abgezogen.
            -- anf_rund <= p_begin < p_end <= end_rund
            f :=
              sum( coalesce(tplp_min / 60, timediff(tplp_begin, tplp_end)) )
              FROM tplanpause
              WHERE tplp_tpl_name = tplanname
                -- Fallunterscheidung Stempelung am gleichen Tag oder Mitternacht
                AND CASE
                      -- Stempelung am gleichen Tag
                      WHEN new.bd_anf_rund::date = new.bd_end_rund::date THEN
                          -- 20:00 <= 21:00 bis 22:00 Pause <= 23:00
                              new.bd_anf_rund::time <= tplp_begin
                          AND new.bd_end_rund::time >= tplp_end

                      -- Stempelung über Mitternacht hinweg
                      -- Beachte Abstand zwischen Anfang und Ende kleiner als 15 h.
                      WHEN new.bd_anf_rund::date < new.bd_end_rund::date THEN
                          (
                              ( -- Pause liegt vor Mitternacht
                                -- 21:00 <= 22:00 bis 23:00 Pause >= 01:00
                                    new.bd_anf_rund::time <= tplp_begin
                                AND new.bd_end_rund::time <= tplp_end
                              )
                          OR  ( -- Pause liegt nach Mitternacht
                                -- 23:00 >= 01:00 bis 02:00 Pause <= 03:00
                                    new.bd_anf_rund::time >= tplp_begin
                                AND new.bd_end_rund::time >= tplp_end
                              )
                          -- OR: Pause über Mitternacht nicht implementiert
                          )

                      -- ELSE: andere Fälle (anf > end, end is null) nicht relevant
                    END
            ;

            new.bd_gleitpause := coalesce(new.bd_gleitpause, 0) + coalesce(f, 0);
        --

        _recalc_pausensaldo := false;

        -- 1) Anfang vor Pausenbeginn, Ende in der Pause aber nicht danach (sonst wäre es ja voll umschlossen).
            -- anf_rund <= p_begin < end_rund <= p_end
            f1 := 0; f2 := 0; f3 := 0;
            -- f1 hält die Mindestpause, f2 die noch übrige Zeit bis zum Ende der Pause, f3 die Zeit die der Pause durch diese Stempelung verloren geht.
            SELECT
              -- f1:
              coalesce(tplp_min / 60, timediff(tplp_begin, tplp_end)),
              -- f2:
              timediff(new.bd_end_rund::time, tplp_end),
              -- f3:
              timediff(tplp_begin, new.bd_end_rund::time)
            INTO f1, f2, f3
            FROM tplanpause
            WHERE tplp_tpl_name = tplanname
              -- Ende ist innerhalb der Pause + Anfang genau Pausenbegin oder früher
              AND new.bd_anf_rund::time <= tplp_begin
              AND new.bd_end_rund::time <  tplp_end
              -- Fallunterscheidung Stempelung am gleichen Tag oder Mitternacht
              AND CASE
                    -- Stempelung am gleichen Tag
                    WHEN new.bd_anf_rund::date = new.bd_end_rund::date THEN
                        new.bd_anf_rund::time <= tplp_begin

                    -- Stempelung über Mitternacht hinweg
                    -- Beachte Abstand zwischen Anfang und Ende kleiner als 15 h.
                    WHEN new.bd_anf_rund::date < new.bd_end_rund::date THEN
                        new.bd_anf_rund::time >= tplp_begin

                    -- ELSE: andere Fälle (anf > end, end is null) nicht relevant
                  END
            ;

            RAISE NOTICE '-- 1) Anfang vor Pausenbeginn, Ende in der Pause aber nicht danach: bd_id: %, time1 = %, f1 = %, f2 = %, f3 = %', new.bd_id, time1, f1, f2, f3;

            -- Pausenzeitberechnung: Wieviel Pause wurde schon genommen. Wieviel muss noch genommen werden.
            IF f1 > f2 THEN -- Mindestpause größer als Rest bis zum Pausenende. Es muss also eine Differenz noch von der Arbeitszeit abgezogen werden.
                RAISE NOTICE '-- 1) true: bd_id: %, f1 = %, f2 = %, f1-f2 = %', new.bd_id, f1, f2, f1 - f2;
                f1 := f1 - f2; -- Die Differenz zwischen Mindestpause und Restzeit ergibt die Pausenunterschreitung, die noch abgezogen werden muss.
                new.bd_restpause  := coalesce(f1, 0); -- Diese anteilige Pausenzeit macht die Stempelung geltend. Die nächste Stempelung holt sich diese Zeit und berechnet aufgrund dessen, wieviel Spiel sie noch hat.
                new.bd_gleitpause := coalesce(new.bd_gleitpause, 0) + coalesce(f1, 0); -- Pausenabzug dazuaddieren
            ELSE
                RAISE NOTICE '-- 1) false / SKIP: bd_id: %, f1 = %, f2 = %, f1-f2 = %', new.bd_id, f1, f2, f1 - f2;
            END IF;
        --

        -- 2) Falls die ganze Stempelung innerhalb einer Pause ist, muss die komplette Stempelzeit gemarkt werden und evtl. Pausenabzug.
            -- p_begin < anf_rund <= end_rund < p_end
            f1 := 0; f2 := 0; f3 := 0; rp := 0; gestempelte_pause := 0;
            -- f1 hält die Mindestpause, f2 die gesamte Zeit in der Pause, f3 Zeit bis zum Pausenende.
            SELECT
              -- f1:
              coalesce(tplp_min / 60, timediff(tplp_begin, tplp_end)),
              -- f2:
              timediff(new.bd_anf_rund::time, new.bd_end_rund::time),
              -- f3:
              timediff(new.bd_end_rund::time, tplp_end),
              -- time1:
              tplp_begin
            INTO f1, f2, f3, time1
            FROM tplanpause
            WHERE tplp_tpl_name = tplanname
              AND new.bd_anf_rund::date = new.bd_end_rund::date -- Nur möglich am gleichen Tag, denn Pause über Mitternacht ist nicht implementiert.
              AND new.bd_anf_rund::time > tplp_begin
              AND new.bd_end_rund::time < tplp_end
            ;

            RAISE NOTICE '-- 2) Falls die ganze Stempelung innerhalb einer Pause ist, muss die komplette Stempelzeit gemarkt werden und evtl. Pausenabzug.: bd_id: %, time1 = %, f1 = %, f2 = %, f3 = %', new.bd_id, time1, f1, f2, f3;

            -- Pausenzeitberechnung: Wieviel Pause wurde schon genommen? Wieviel muss noch genommen werden?
            IF f1 > 0 THEN -- Sonst gibt es diesen Fall nicht (keine Mindestpause -> diese Stempelung hat keine Pause getroffen).
                _recalc_pausensaldo := true;
            END IF;
        --

        -- 3) Anfang vor Pausenende, Ende nach Pausenende, Anfang aber nicht vor Pausenanfang (sonst wäre es ja voll umschlossen)
            -- p_begin <= anf_rund <= p_end <= end_rund
            f1 := 0; f2 := 0; f3 := 0; rp := 0; gestempelte_pause := 0;
            -- In f1 steht wieder die Mindestpause. f2 hält die Zeit, die die Stempelung in die Pause hineinragt.
            -- time1 hält die Anfangszeit der Pause, um die es gerade geht. Dadurch können wir die anderen Stempelungen ermitteln, die auch in dieser Pause enden (vor dieser aktuellen Stempelung).
            SELECT
              -- f1:
              coalesce(tplp_min / 60, timediff(tplp_begin, tplp_end)),
              -- f2:
              timediff(new.bd_anf_rund::time, tplp_end),
              -- time1:
              tplp_begin
            INTO f1, f2, time1
            FROM tplanpause
            WHERE tplp_tpl_name = tplanname
              -- Anfang ist innerhalb der Pause + Anfang fällt genau auf Pausenende ausschließen.
              AND new.bd_anf_rund::time < tplp_end    -- Anfang for Pausenende, also innerhalb der Pause Pause angestempelt
              AND new.bd_anf_rund::time > tplp_begin  -- Anfang nicht for dem Pausenstart Das wäre Fall 1!
              AND new.bd_end_rund::time > tplp_end    -- Ende nach Pausenende

              -- Fallunterscheidung Stempelung am gleichen Tag oder Mitternacht
              AND CASE
                    -- Stempelung am gleichen Tag
                    WHEN new.bd_anf_rund::date = new.bd_end_rund::date THEN
                        new.bd_end_rund::time >= tplp_end

                    -- Stempelung über Mitternacht hinweg
                    -- Beachte Abstand zwischen Anfang und Ende kleiner als 15 h.
                    WHEN new.bd_anf_rund::date < new.bd_end_rund::date THEN
                        new.bd_end_rund::time <= tplp_end

                    -- ELSE: andere Fälle (anf > end, end is null) nicht relevant
                  END
            ;

            RAISE NOTICE '-- 3) Anfang vor Pausenende, Ende nach Pausenende, Anfang aber nicht vor Pausenanfang: bd_id: %, time1 = %, f1 = %, f2 = %, f3 = %', new.bd_id, time1, f1, f2, f3;

            IF f1 > 0 THEN -- Sonst gibt es diesen Fall nicht (keine Mindestpause -> diese Stempelung hat keine Pause getroffen).
                _recalc_pausensaldo := true;
            END IF;

        -- Pausenzeitberechnung: Wieviel Pause wurde schon genommen? Wieviel muss noch genommen werden?
            IF _recalc_pausensaldo THEN
                -- Bereits genommene Pausenzeit ermitteln.
                -- 2) ganze Stempelung innerhalb einer Pause und 3)
                SELECT
                  -- rp:
                    -- Pausenzeiten, die vorherige Stempelungen schon geltend gemacht haben.
                    -- Beachte Fall: feste Pause in Zeitraum mit bestimmter Zeit (von 12:00 bis 13:00 Uhr sind 30 min zu nehmen)
                  SUM(bd_restpause),

                  -- gestempelte_pause:
                  -- gestempelte Pausenzeit =
                  (   -- Zeit in Pause vor Stempelbeginn
                      greatest(timediff(time1, new.bd_anf_rund::time), 0)
                      -- MINUS andere Zeiten, die in der Pause genommen wurden.
                      - sum(
                          -- Zwischen Anfang bzw. Pausenbeginn (je nachdem was später ist) und Ende.
                          greatest( -- bereits hier negativ zu 0, da dies bedeutet der Datensatz liegt komplett vor der Pause
                                timediff(
                                    CASE
                                      -- Stempelung über Mitternacht, dann Stempelung definitiv vor Pausenbeginn (Pause über Mitternacht nicht implementiert).
                                      WHEN bd_anf_rund::date < bd_end_rund::date THEN
                                          time1
                                      -- Stempelung am gleichen Tag, dann Stempelung ggf. nach Pausenbeginn
                                      ELSE
                                          greatest(time1, bd_anf_rund::time)
                                    END
                                    -- Ende ist innerhalb Pause
                                    , bd_end_rund::time
                                )
                                , 0
                        )
                      )
                  )

                INTO rp, gestempelte_pause
                FROM bdep
                WHERE bd_minr = new.bd_minr
                  AND bd_individwt_mpl_date = new.bd_individwt_mpl_date
                  -- Wir holen die Zeiten aller vorigen Stempelungen. Durch das greatest oben werden Stempelungen automatisch 0, die komplett vor der Pause liegen und keine Berührung haben
                  AND bd_end <  new.bd_anf
                ;

                RAISE NOTICE '-- _recalc_pausensaldo: Bereits genommene Pausenzeit ermitteln: bd_id: %, rp = %, gestempelte_pause = %', new.bd_id, rp, gestempelte_pause;

                -- geltend gemachte Pausezeit der vorigen Stempelungen + gestempelte Pausezeit zwischen Stempelungen (nicht negativ)
                rp := coalesce(rp, 0) + coalesce(gestempelte_pause, 0);

                -- Wieviel muss noch genommen werden.
                -- es gibt noch zu verteilende Pausenzeit
                IF (f1 - coalesce(rp, 0)) > 0 THEN
                    RAISE NOTICE '-- _recalc_pausensaldo: bd_id: %, time1 = %, f1 = %, f2 = %, rp = %, gestempelte_pause = %, least = %', new.bd_id, time1, f1, f2, rp, gestempelte_pause, least((f1 - coalesce(rp, 0)), f2);
                    -- maximal die zu verteilende Pausenzeit, ansonsten ganze Zeit in Pause.
                    f1 := least((f1 - coalesce(rp, 0)), f2);
                    -- Pausenabzug dazuaddieren
                    new.bd_gleitpause := coalesce(new.bd_gleitpause, 0) + coalesce(f1, 0);
                END IF;
            END IF;
        --

        -- Wenn sich Stempelzeit geändert hat, Nachtstunden NULL setzen damit diese neu berechnet werden.
        -- Sonst nicht neu berechnen, damit manuelle Änderungen erhalten bleiben
        IF TG_OP = 'UPDATE' THEN
            IF (new.bd_anf <> old.bd_anf) OR (new.bd_end <> old.bd_end) OR (new.bd_karenz <> old.bd_karenz) OR (new.bd_karenz_end <> old.bd_karenz_end) THEN
                new.bd_nachtstunden := NULL;
            END IF;
        END IF;

        SELECT * FROM tplan INTO planRec WHERE tpl_name = tplanname; -- Tagesplan holen

        -- (Neu)Berechnung der Nachtstunden
        IF planRec.tpl_nachterlaubt AND new.bd_nachtstunden IS NULL THEN
            -- Vorsichtshalber mal 0 setzen
            new.bd_nachtstunden := 0;
            new.bd_nachtstunden := tsystem.timestamps__intervals__intersect(new.bd_anf_rund, new.bd_end_rund, planRec.tpl_nachtv,planRec.tpl_nachtb); -- PHKO  #10498
            new.bd_nachtstunden := MAX(new.bd_nachtstunden,0);
        END IF;
        --

        new.bd_saldo := timediff(new.bd_anf_rund, new.bd_end_rund) - coalesce(new.bd_blockpause, 0) - coalesce(new.bd_gleitpause, 0);

        -- Raucherpause von der Stempelung direkt abziehen!
        IF new.bd_end_rund IS NOT null AND TSystem.Settings__GetBool('bdep__saldo__ohne__raucherpause', false) THEN
          new.bd_saldo := new.bd_saldo - coalesce(tpersonal.llv__bdpab__rpause__round__by__bdep(new), 0);
        END IF;

        -- vollständig während der Arbeitszeit durchgeführte Dienstgänge werden von der Präsenzzeit abgezogen
        _stunden_dienstgang_during_bdep := /*SELECT*/ sum(bdab_stu)
               FROM bdepab
              WHERE bdab_minr = new.bd_minr
                AND bdab_stu IS NOT null -- nur gesetzt, wenn über Uhrzeiten
                AND bdab_anft IS NOT null AND bdab_endt IS NOT null
                AND (bdab_anf + bdab_anft >= new.bd_anf_rund AND bdab_end + bdab_endt <= new.bd_end_rund)
                AND tpersonal.bdeabgruende__type__dienstgang(bdab_aus_id)
                AND NOT bdab_buch;
        IF _stunden_dienstgang_during_bdep IS NOT null THEN
            new.bd_saldo := new.bd_saldo - _stunden_dienstgang_during_bdep;
        END IF;

        IF new.bd_saldo < 0 THEN
            new.bd_saldo := 0;
        END IF;

        -- Maschinenausfälle beenden
        UPDATE maschausf SET
          ma_end = currenttime()
        WHERE ma_end IS NULL
          AND ma_efftime IS NULL
          AND ma_minr = new.bd_minr
          AND ma_anf::date <= new.bd_anf::date;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;
--
